/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "test_common.h"

int main(int argc, char **argv)
{
  mx_return_t r;
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  mx_endpoint_addr_t addr2;
  uint64_t nic_id;
  uint32_t eid;
  uint64_t nic_id2;
  uint32_t eid2;
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  char send_buff[80];
  char recv_buff[80];
  char blah_buff[80];
  mx_status_t s1, s2;
  mx_request_t send_req;
  mx_request_t recv_req;
  uint32_t result;

  memset(send_buff, 'x', 79);
  memset(recv_buff, 'y', 79);
  memset(blah_buff, 'y', 79);
  send_buff[79] = '\0';
  recv_buff[79] = '\0';
  blah_buff[79] = '\0';

  mx_set_error_handler(MX_ERRORS_RETURN);
  mx_init();
  r = mx_open_endpoint(MX_ANY_NIC, argc, 0, NULL, 0, &ep);
  insist(r == MX_SUCCESS);

  mx_get_endpoint_addr(ep, &addr);
  mx_decompose_endpoint_addr(addr, &nic_id, &eid);
  mx_connect(ep, nic_id, eid, 0, MX_INFINITE, &addr2);

  strcpy(send_buff+1, "hello world");
  blah_buff[1] = 'h';
  blah_buff[2] = 'e';
  blah_buff[3] = 'l';
  blah_buff[4] = 'l';
  blah_buff[5] = 'o';
  blah_buff[6] = ' ';
  blah_buff[7] = 'w';

  send_seg.segment_ptr = send_buff+1;
  send_seg.segment_length = strlen(send_buff+1)+1;
  recv_seg.segment_ptr = recv_buff+1;
  recv_seg.segment_length = 7;

  /* post a receive that is smaller than the send */
  r = mx_irecv(ep, &recv_seg, 1, MAKE_MATCH(10, 11), MX_MATCH_MASK_NONE,
	       (void*)0x42, &recv_req);
  insist(r == MX_SUCCESS);
  r = mx_isend(ep, &send_seg, 1, addr, MAKE_MATCH(10, 11), NULL, &send_req);
  insist(r == MX_SUCCESS);

  mx_wait(ep, &recv_req, MX_INFINITE, &s1, &result);
  mx_wait(ep, &send_req, MX_INFINITE, &s2, &result);

  mx_decompose_endpoint_addr(s1.source, &nic_id2, &eid2);

  /* make sure we the status is what we expected */
  insist(nic_id == nic_id2);
  insist(eid == eid2);
  insist(s1.match_info >> 32 == 10);
  insist((s1.match_info & 0xffffffff) == 11);
  insist(s1.msg_length == 12);
  insist(s1.xfer_length == 7);
  insist(s1.context == (void*)0x42);

  /* and the buffer as well */
  insist(memcmp(recv_buff, blah_buff, 80) == 0);

  mx_close_endpoint(ep);
  mx_finalize();

  return 0;
}
